global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_3_3Prop")
local handlestate

handlestate = 0

-- Inertial Dampers

global function AnimDone()
	local anim
	local ce8 = FindNodeByName("ce8")
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_P03_Handle_Anim_Panel03_Handle_Down_Idle")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P03_Handle_Anim_Panel03_Handle_Up_Idle")
		ce8:Trigger()
	end

	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	controls.script.TurnOffInterface()

	local anim = FindNodeByShortName("EM_ANIMATOR_P03_Handle_Anim_Panel03_Handle_Up")

	handlestate = 1

	FindNodeByName("Ob3_3SoundDown"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	controls.script.TurnOffInterface()

	local anim = FindNodeByShortName("EM_ANIMATOR_P03_Handle_Anim_Panel03_Handle_Down")

	handlestate = 0

	FindNodeByName("Ob3_3SoundUp"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	FindNodeByName("AllControlsScript").script.TurnOffInterface()

	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end

	FindNodeByName("Console3InteractableScript").script.Object3State = handlestate

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2260:Inertial Dampers: These compensate for the speed of travel, and stop us getting thrown around. In theory, anyway. Must get them fixed...
		else
			--VO Console Control Text
			amy::SID_2261:I've seen the Doctor using these to stop things shaking around so much. But I don't think they're working too well...
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim
	
	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_P03_Handle_Anim_Panel03_Handle_Down_Idle")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P03_Handle_Anim_Panel03_Handle_Down")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	handlestate = 0
end
